radio_ops = {}

-- requires => all modules that are required by this module. contains => all submodules this module contains.
-- This difference is made, to prevent the import of submodules without its parent
radio_ops.requires = {"util"} -- attack mission as dynamic dependency
radio_ops.contains = {"radio_ops.DATA", "radio_ops.watcher"}



---handle for f10 on/off menue
---@param MODE string "OFF" or "ON"
function radio_ops.set_radio(MODE)
    if MODE == "ON" then
        radio_ops.watcher.enable_radio()
    elseif MODE == "OFF" then
        radio_ops.watcher.disable_radio()
    end
end


function radio_ops.init()
    util.missionCommands.add("/Radio Transmissions", "ON", radio_ops.set_radio, "ON")
    util.missionCommands.add("/Radio Transmissions", "OFF", radio_ops.set_radio, "OFF")

    world.addEventHandler(radio_ops.watcher.eventHandler)
    timer.scheduleFunction(radio_ops.watcher.TaskTimer, {}, timer.getTime() + radio_ops.DATA.TASK_UPDATE_INTVL)

    radio_ops.set_radio("ON")
end


function radio_ops.cleanup()
    util.missionCommands.remove("/Radio Transmissions", "ON")
    util.missionCommands.remove("/Radio Transmissions", "OFF")

    world.removeEventHandler(duty_shifts.watcher.eventHandler)
end