attack_mission.DATA = {}

attack_mission.DATA.HARD = {}
attack_mission.DATA.EASY = {}

attack_mission.DATA.PR_CIV = {}
attack_mission.DATA.PR_NOARMOUR = {}
attack_mission.DATA.PR_ARMOR = {}
attack_mission.DATA.PR_AAA = {}
attack_mission.DATA.PR_SAM = {}

attack_mission.DATA.SHPR_CARGO = {}


attack_mission.DATA.SOUND = "MissionStart.ogg"
attack_mission.DATA.SOUND_END = "MissionEnd.ogg"

attack_mission.DATA.UNIT_TEMPLATE = {
    ["type"] = nil,
    ["x"] = nil,
    ["y"] = nil,
    ["name"] = nil,
    ["skill"] = "Excellent",
    ["heading"] = 0,
}

attack_mission.DATA.GROUP_TEMPLATE = {
    ["name"] = nil,
    ["route"] = {},
    ["taskSelected"] = true,
    ["start_time"] = 0,
    ["task"] = "Ground Nothing",
}

attack_mission.DATA.COLLECTION = {
    ["Kub 1S91 str"] = {
        ["Kub 2P25 ln"] =           { min = 1, max = 2 },
        ["Ural-375"] =        { min = 1, max = 1 },
    },
    ["SA-18 Igla-S comm"] = { 
        ["SA-18 Igla-S manpad"] =   { min = 1, max = 3 },
    },
    ["SA-11 Buk CC 9S470M1"] = {
        ["SA-11 Buk SR 9S18M1"] =   { min = 1, max = 1 },
        ["SA-11 Buk LN 9A310M1"] =  { min = 1, max = 2 },
        ["Ural-375"] =        { min = 1, max = 1 },
    },
    ["S-300PS 54K6 cp"] = {
        ["S-300PS 64H6E sr"] =      { min = 1, max = 1 },
        ["S-300PS 40B6MD sr"] =     { min = 1, max = 1 },
        ["S-300PS 40B6M tr"] =      { min = 1, max = 1 },
        ["S-300PS 5P85D ln"] =      { min = 2, max = 2 },
        ["Ural-375"] =        { min = 1, max = 1 },
    }
}

-- all mission events this module can throw. Only use this locally
attack_mission.DATA.EVENT_TYPES = {
    AZ_CREATE   =  1,
    AZ_SUCCESS  =  2,
    AZ_FAILURE  =  3,
}

-- event template every throw uses
attack_mission.DATA.EVENT_TEMPLATE = {
    name    = "AZ",
    id      = nil, -- event id
    group   = nil, -- group
    zName    = nil, -- zone name the event occured in
}

attack_mission.DATA.HARD.COUNT = {
    MIN = 30,
    MAX = 35,
}

attack_mission.DATA.HARD.DEFINITION = {
    ["MAIN"] = {
        ["T-90"]    =           { prob = 0.25 },
        ["T-72B3"]  =           { prob = 0.50 },
        ["BTR-82A"] =           { prob = 0.75 },
        ["BTR-80"]  =           { prob = 0.75 },
        ["T-80UD"]  =           { prob = 0.50 },
        ["ZSU-23-4 Shilka"] =   { prob = 0.2  },
        ["Osa 9A33 ln"] =       { prob = 0.4  },
        ["SA-18 Igla-S comm"] = { prob = 0.2  },
        ["2S6 Tunguska"] =      { prob = 0.4  },
    },
    ["SPECIAL"] = {
        ["Kub 1S91 str"] =          { min = 1, max = 2, att = {minDist = 50, maxDist = 60} },
        ["SA-11 Buk CC 9S470M1"] =  { min = 1, max = 1, att = {minDist = 60, maxDist = 80} },
        ["S-300PS 54K6 cp"] =       { min = 1, max = 2, att = {minDist = 60, maxDist = 80} },
    }
}

attack_mission.DATA.EASY.COUNT = {
    MIN = 22,
    MAX = 28,
}

attack_mission.DATA.EASY.DEFINITION = {
    ["MAIN"] = {
        ["T-90"]    =           { prob = 0.2  },
        ["T-72B3"]  =           { prob = 0.5  },
        ["BTR-82A"] =           { prob = 0.3  },
        ["BTR-80"]  =           { prob = 0.4  },
        ["T-80UD"]  =           { prob = 0.25 },
        ["ZSU-23-4 Shilka"] =   { prob = 0.2  },
        ["GAZ-66"]  =           { prob = 0.9  },
    },
    ["SPECIAL"] = {}
}

attack_mission.DATA.PR_CIV.COUNT = {
    MIN = 40,
    MAX = 20,
}

attack_mission.DATA.PR_CIV.DEFINITION = {
    ["MAIN"] = {
        ["LAZ Bus"]     =        { prob = 1.0  },
        ["LiAZ Bus"]    =        { prob = 1.0  },
        ["IKARUS Bus"]  =        { prob = 0.1  },
        ["Ural ATsP-6"] =        { prob = 1.0  },
        ["ZIL-4331"]    =        { prob = 0.5  },
    },
    ["SPECIAL"] = {}
}

attack_mission.DATA.PR_NOARMOUR.COUNT = {
    MIN = 40,
    MAX = 20,
}

attack_mission.DATA.PR_NOARMOUR.DEFINITION = {
    ["MAIN"] = {
        ["Hummer"]              =           { prob = 0.5  },
        ["Tigr_233036"]         =           { prob = 0.5  },
        ["UAZ-469"]             =           { prob = 0.5  },
        ["ATZ-10"]              =           { prob = 0.5  },
        ["M978 HEMTT Tanker"]   =           { prob = 0.3  },
        ["GAZ-66"]              =           { prob = 0.5  },
        ["HEMTT TFFT"]          =           { prob = 0.3  },
        ["KrAZ6322"]            =           { prob = 0.5  },
        ["Land_Rover_101_FC"]   =           { prob = 0.5  },
        ["Ural-375"]            =           { prob = 0.5  },
    },
    ["SPECIAL"] = {}
}

attack_mission.DATA.PR_ARMOR.COUNT = {
    MIN = 25,
    MAX = 15,
}

attack_mission.DATA.PR_ARMOR.DEFINITION = {
    ["MAIN"] = {
        ["BTR-82A"]         = { prob = 0.5  },
        ["BTR_D"]           = { prob = 0.5  },
        ["Cobra"]           = { prob = 0.5  },
        ["T-72B3"]          = { prob = 0.5  },
        ["T-55"]            = { prob = 0.5  },
        ["T-90"]            = { prob = 0.5  },
        ["ZBD04A"]          = { prob = 0.5  },
        ["PLZ05"]           = { prob = 0.3  },
        ["M4_Sherman"]      = { prob = 0.5  },
        ["SpGH_Dana"]       = { prob = 0.2  },
        ["Uragan_BM-27"]    = { prob = 0.1  },
    },
    ["SPECIAL"] = {}
}

attack_mission.DATA.PR_AAA.COUNT = {
    MIN = 20,
    MAX = 10,
}

attack_mission.DATA.PR_AAA.DEFINITION = {
    ["MAIN"] = {
        ["Ural-375 ZU-23 Insurgent"]    = { prob = 0.5  },
        ["ZSU_57_2"]                    = { prob = 0.5  },
        ["ZSU-23-4 Shilka"]             = { prob = 0.5  },
        ["bofors40"]                    = { prob = 0.5  },
        ["flak18"]                      = { prob = 0.5  },
        ["S-60_Type59_Artillery"]       = { prob = 0.5  },
        ["ZU-23 Insurgent"]             = { prob = 0.5  },
        
    },
    ["SPECIAL"] = {}
}

attack_mission.DATA.PR_SAM.COUNT = {
    MIN = 15,
    MAX = 5,
}

attack_mission.DATA.PR_SAM.DEFINITION = {
    ["MAIN"] = {
        ["SA-11 Buk CC 9S470M1"]        = { prob = 0.3  },
        ["Kub 1S91 str"]                = { prob = 0.3  },
        ["S-300PS 54K6 cp"]             = { prob = 0.2  },
        ["Strela-10M3"]                 = { prob = 0.5  },
        ["2S6 Tunguska"]                = { prob = 0.5  },
        ["Osa 9A33 ln"]                 = { prob = 0.5  },
        ["Strela-1 9P31"]               = { prob = 0.5  },
    },
    ["SPECIAL"] = {}
}


attack_mission.DATA.SHPR_CARGO.COUNT = {
    MIN = 15,
    MAX = 5,
}

attack_mission.DATA.SHPR_CARGO.DEFINITION = {
    ["MAIN"] = {
        ["Dry-cargo ship-1"]        = { prob = 0.3  },
        ["Dry-cargo ship-2"]                = { prob = 0.3  },
        ["ELNYA"]             = { prob = 0.2  },
        ["HandyWind"]                 = { prob = 0.5  },
    },
    ["SPECIAL"] = {}
}