jtac = {}

-- requires => all modules that are required by this module. contains => all submodules this module contains.
-- This difference is made, to prevent the import of submodules without its parent
jtac.requires = {"util"}
jtac.contains = {"jtac.DATA", "jtac.helpers",}

-- all known jtacs are saved in this table
jtac.known = {}

--- creates a jtac (spawnes). Meant to be used by the jtac events
--- @param name string name of the jtac
--- @param typ string typ enum of the jtac.
function jtac.spawn(name, target, typ, fallbackPos)
    local ok, jtGroup = true, nil

    ok, jtGroup = util.error.wpcall(function() return jtac.helpers.getGroupDataFromKnown(name) end)
    if not ok then util.error.raise(jtGroup) return nil end

    if not jtGroup then
        ok, jtGroup = util.error.wpcall(function() return jtac.helpers.getGroupDataFromME(name, typ) end)
        if not ok then util.error.raise(jtGroup) end
    end

    if not jtGroup then
        ok, jtGroup = util.error.wpcall(function() return jtac.helpers.generateGenericJtac(name, fallbackPos, typ) end)
        if not ok then util.error.raise(jtGroup) end
    end

    -- set country and categroy
    local DCSGroup = Group.getByName(name)
    local coali = DCSGroup and DCSGroup:getCoalition() or jtac.DATA.JTAC_TEMPLATE.COALITION
    local categ = DCSGroup and DCSGroup:getCategory() or  jtac.DATA.JTAC_TEMPLATE.CATEGORY

    -- TODO: somehow adding an airplane makes the game stutter significantly
    -- Seems to be better with the reaper drone. I cant explain why tho
    coalition.addGroup(coali, categ, jtGroup)

    jtac.helpers.attackTargetGroup(name, target)
end

--- destroyes a jtac (despawnes). Meant to be used by the jtac events
--- @param name string name of the jtac
function jtac.destroy(name)
    local group = Group.getByName(name)

    if group == nil then
        return nil
    end

    group:destroy()
end

-- this function gets called whenever a mission event occurs
function jtac.MEventHandler(event)
    -- this will cut down on if else cases if many multiple events are possible
    local identifier = tostring(event.name) .. tostring(event.id)

    -- event attack zone create
    if identifier == "AZ1" then
        local point = trigger.misc.getZone(event.zName).point
        local pos = { x = point.x, y = point.z }
        jtac.spawn(event.zName .. "_jtac", event.group, "AZ", pos)

    -- event attack zone success
    elseif identifier == "AZ2" then
        jtac.destroy(event.zName .. "_jtac")
    end
end

function jtac.init()
    util.mEvent.registerMEH("AZ", jtac.MEventHandler)
end

function jtac.cleanup()
end