util.conversion = {}

util.conversion.DISTANCE = {
    m_km    = 1e3,
    m_m     = 1e0,
    m_dm    = 1e-1,
    m_cm    = 1e-2,
    m_mm    = 1e-3,
    m_mum   = 1e-6,

    i_nm    = 1852,
    i_m     = 1609.34,
    i_yd    = 0.9144,
    i_ft    = 0.3048,
    i_in    = 0.0254,
}

--- attempts to covert from supplied standard to meters
---
--- INFO: if no standard is supplied this function will assume the input as meter
--- @param d number distance you want to converts
--- @param standard string standard convert to. You may append "m_" (metric) or i_" (imperial) as a prefix for ambiguous units
--- @return number
function util.conversion.toM(d, standard)
    -- checking function arguments
    if not tonumber(d) then error(util.error.argErr(d, "number", 1)) end
    standard = type(standard) == "string" and standard or "m_m"

    -- local pointer to table (just to make it look a bit cleaner xd)
    local tbl = util.conversion.DISTANCE
    local factor = tbl[standard] or tbl["m_" .. standard] or tbl["i_" .. standard]

    if type(factor) ~= "number" then error(util.error.lookupErr(standard, tbl, factor, "number")) end
    return (d * factor)
 end

--- attempts to covert from metrs to supplied standard
---
--- INFO: if no standard is supplied this function will assume the input as meter
--- @param d number distance you want to converts
--- @param standard string standard convert to. You may append "m_" (metric) or i_" (imperial) as a prefix for ambiguous units
--- @return number
function util.conversion.fromM(d, standard)
    -- checking function arguments
    if not tonumber(d) then error(util.error.argErr(d, "number", 1)) end
    standard = type(standard) == "string" and standard or "m_m"

    -- local pointer to table (just to make it look a bit cleaner xd)
    local tbl = util.conversion.DISTANCE
    local factor = tbl[standard] or tbl["m_" .. standard] or tbl["i_" .. standard]

    if type(factor) ~= "number" then error(util.error.lookupErr(standard, tbl, factor, "number")) end
    return factor and (d / factor) or nil
end