util.trigger = {}

--- returns all mission zones places in the mission editor
--- @param name? string name of zone. If not supplied "[A-Za-z]+" as pattern is applied
--- @return table[]|nil @(see DCS trigger.misc.getZone())
function util.trigger.getMissionZones(name)
    name = type(name) == "string" and name or "[A-Za-z]+"
    local zones = {}

    for _i, z in ipairs(env.mission.triggers.zones) do
        -- all trigger zones should start with mission (not case sensitive)
        if util.naming.check(z.name, "mission", {name}) then
            -- this modification is made to keep the structure of trigger.misc.getZone(string name)
            zones[#zones + 1] = {
                point = { x = z.x, y = 0, z = z.y },
                radius = z.radius,
                name = z.name
            }
        end
    end

    return zones
end

--- returns all polygon definition zones places in the mission editor
--- @param name? string name of zone. If not supplied "[A-Za-z]+" as pattern is applied
--- @return table[]|nil
function util.trigger.getPolyZones(name)
    name = type(name) == "string" and name or "[A-Za-z]+"
    local zones = {}

    -- all polygon zone should follow a strict pattern of def[del]+<name>[del]+<index>
    for _i, z in ipairs(env.mission.triggers.zones) do
        if util.naming.checkStrict(z.name, "def", { name, "[0-9]+" }) then
            -- this modification is made to keep the structure of trigger.misc.getZone(string name)
            zones[#zones + 1] = {
                point = { x = z.x, y = 0, z = z.y },
                radius = z.radius,
                name = z.name
            }
        end
    end

    return zones
end

--- retruns a random point inside the trigger zone
--- @param triggerZ table (see DCS trigger zone)
--- @return number|nil, number|nil, nil|string @x, y
function util.trigger.getRndInZone(triggerZ)
    if type(triggerZ) ~= "table" then error(util.error.argErr(triggerZ, "table", 1)) end

    local rPhi, rR = math.random() * 2*math.pi, math.random() * triggerZ.radius
    local x, y, err = util.math.polToCar(rPhi, rR)

    return triggerZ.point.x + x, triggerZ.point.z + y
end