util.object = {}

util.object.classNames = {

}

--- returns the DCS object class name.
--- @param object Object DCS object you want to retrieve the class name from
--- @return string | nil className
function util.object.getClassName(object)
    if type(object) ~= "table" then error(util.error.argErr(object, "table", 1)) end

    return object.className_ and tostring(object.className_) or nil
end

--- returns an array of the objects inheritance path
---@param object Object DCS object you want to retireve the inheritance path from
---@return string[] path base class first object class last
function util.object.getInheritancePath(object)
    if type(object) ~= "table" then error(util.error.argErr(object, "table", 1)) end

    if not object.parentClass_ then
        return({tostring(object.className_)})
    end

    local tree = util.object.getInheritancePath(object.parentClass_)
    tree[#tree+1] = tostring(object.className_)

    return tree
end

--- returns the DCS category value as well as its category name for the given object
---@param object Object DCS Object
---@return nil notFound if category is unobtainable (most likely not a dcs Object)
--- @return integer categoryIndex, string categoryName if category could be obtained
function util.object.getCategoryClassAware(object)
    if type(object) ~= "table" then error(util.error.argErr(object, "table", 1)) end

    local categoryTable = object.Category
    if not categoryTable then return nil end

    local categoryIndex = object:getDesc().category
    return categoryIndex, tostring(util.misc.find(categoryTable, categoryIndex))
end