jtac.helpers = {}



-- starting frequency
jtac.helpers.availableFreq = 133000000

function jtac.helpers.getAvailableFreq()
    local freq = jtac.helpers.availableFreq
    jtac.helpers.availableFreq = jtac.helpers.availableFreq + 1e6
    return freq
end


--- generates a attack zone specific jtac (if no ME is provided)
--- @param name string name of the jtac. The zone is generated out of this name so make sure it exists
--- @return table @jtac group (see DCS Group)
function jtac.helpers.generateAZJtac(name, pos)
    if type(name) ~= "string" then error(util.error.argErr(name, "string", 1)) end
    if type(pos) ~= "table" then error(util.error.argErr(pos, "table", 2)) end

    -- copy template and fill in values and set name and unit name
    local template = util.misc.deepCopy(jtac.DATA.JTAC_TEMPLATE.GROUP)
    template.name, template.units[1].name = name, name .. "_unit"

    -- set available frequency and increase frequency by 1000
    template.route.points[1].task.params.tasks[1].params.frequency = jtac.helpers.getAvailableFreq()

    -- set jtac at random angle, predefined meter away from the triggerzone
    local phi, r = math.random() * 2*math.pi, math.random(jtac.DATA.AZ_DIST.MIN, jtac.DATA.AZ_DIST.MAX)
    local x, y = util.math.polToCar(phi, r)
    x, y = pos.x + x, pos.y + y
    template.units[1].x, template.units[1].y = x, y
    template.route.points[1].x, template.route.points[1].y = x, y

    -- set altitude to be 10000 higher than ground
    local rAlt = math.random(jtac.DATA.AZ_RALT.MIN, jtac.DATA.AZ_RALT.MAX)
    local altitude = land.getHeight({x = x, y = y}) + rAlt
    template.route.points[1].alt = altitude
    template.route.points[1].task.params.tasks[4].params.altitude = altitude
    template.units[1].alt = altitude

    return template
end

--- generates a generic jtac depending on the type
--- @param name string name of the jtac
--- @param typ string typ enum of the jtac.
--- @return table @jtac group (see DCS Group)
function jtac.helpers.generateGenericJtac(name, pos, typ)
    local jtGroup = nil

    -- TYPE JTAC --
    if typ == "AZ" then
        jtGroup = jtGroup or jtac.helpers.generateAZJtac(name, pos)
    end

    -- TYPE ... --

    if not jtGroup then error(util.error.preconditionFailedErr("JTAC type", tostring(typ) .. " is not a recoginized jtac type")) end

    -- save generated jtGroup
    jtac.known[name] = {}
    jtac.known[name].groups = util.misc.deepCopy(jtGroup)
    jtac.known[name].typ = typ

    jtGroup.lateActivation = false -- set late activation to false

    return jtGroup
end

function jtac.helpers.getGroupDataFromME(name, typ)
    if type(name) ~= "string" then error(util.error.argErr(name, "string", 1)) end
    if type(typ) ~= "string" then error(util.error.argErr(typ, "string", 2)) end

    local jtGroup = util.group.generateGroupTableFromME(name)

    -- jtac is not known but there is a existing ME group available. Most likely jtac.DATA.PRE_REGISTER == false
    if jtGroup ~= nil then
        jtac.known[name] = {}
        jtac.known[name].group = util.misc.deepCopy(jtGroup)
        jtac.known[name].typ = typ

        jtGroup.lateActivation = false -- set late activation to false
    end

    return jtGroup
end

function jtac.helpers.getGroupDataFromKnown(name)
    local jtGroup = nil

    -- jtac is currently known and we can just copy the existing one
    if jtac.known[name] ~= nil then
        jtGroup = util.misc.deepCopy(jtac.known[name].group)

        jtGroup.lateActivation = false -- set late activation to false
    end

    return jtGroup
end