duty_shifts = {}

-- requires => all modules that are required by this module. contains => all submodules this module contains.
-- This difference is made, to prevent the import of submodules without its parent
duty_shifts.requires = {"util"} -- attack mission as dynamic dependency
duty_shifts.contains = {"duty_shifts.watcher", "duty_shifts.DATA"}

function duty_shifts.init()
    -- poulate the dynamic on_duty units with the user-defined list
    for k, v in pairs(duty_shifts.DATA.monitored_units) do
        duty_shifts.DATA.on_duty[k] = k
    end

    -- event handler for engine-shutdown/crash
    -- timer for RTB
    world.addEventHandler(duty_shifts.watcher.eventHandler)
    timer.scheduleFunction(duty_shifts.watcher.TaskTimer, {}, timer.getTime() + duty_shifts.DATA.TASK_UPDATE_INTVL)
end

function duty_shifts.cleanup()
    world.removeEventHandler(duty_shifts.watcher.eventHandler)
    duty_shifts.watcher.revert_changes()
end