duty_shifts.watcher = {}
-- holds all handler functions
duty_shifts.watcher.eventHandler = {}


-- timer monitors which aircraft are RTB
-- only aircraft specified in DATA are considered
-- 
-- all rtb aircraft are respawned as defined in the ME
function duty_shifts.watcher.TaskTimer()
     
    local iter_dict = util.misc.deepCopy(duty_shifts.DATA.on_duty)
    for g_key, g_me in pairs(iter_dict) do
        
        local group = Group.getByName(g_key)

        if group ~= nil then
            local controller = group:getController()
            local hasTask = controller:hasTask()

            if hasTask == false then
                duty_shifts.watcher.call_next_duty(group, g_key)
            end
        end
    end

    timer.scheduleFunction(duty_shifts.watcher.TaskTimer, {}, timer.getTime() + duty_shifts.DATA.TASK_UPDATE_INTVL)
end


-- monitor dcs events
--
-- monitored events are: 
--      S_EVENT_ENGINE_SHUTDOWN:
--              All groups with that event are destroyed,
--              as long as they've been marked as RTB
--              by the RTB-watcher.
--
--      S_EVENT_CRASH:
--              All groups which crash and are RTB are deleted.
--              Crashed groups which have been on duty are replaced
--              with a new copy, taken from the ME
function duty_shifts.watcher.eventHandler:onEvent(event)
    -- there was an error in the dcs event engine => return with satus code false
    if event == nil or event.initiator == nil then 
        return false
    end

    -- any unit was killed
    if event.id == world.event.S_EVENT_ENGINE_SHUTDOWN then
        -- get the callers group
        local group = event.initiator:getGroup()
        local name = group:getName()

        if duty_shifts.DATA.on_rtb[name] ~= nil then
            group:destroy()
            duty_shifts.DATA.on_rtb[name] = nil
        end
    end 

    if event.id == world.event.S_EVENT_CRASH then
        -- get the callers group
        local group = event.initiator:getGroup()
        local name = group:getName()

        if duty_shifts.DATA.on_duty[name] ~= nil then
            duty_shifts.watcher.call_next_duty(group, name)
        end

        if duty_shifts.DATA.on_rtb[name] ~= nil then
            -- just delete the unit from rtb-queue, no other action required
            duty_shifts.DATA.on_rtb[name] = nil
        end
    end

    return true
end

-- create the 'next on duty' group
-- the created group is identical to the current group
--
-- INFO: alters dicts in DATA, moves the current group to RTB
function duty_shifts.watcher.call_next_duty(group, g_key)
    local g_me = duty_shifts.DATA.on_duty[g_key]

    local g_name = group:getName()
    local coal_id = group:getCoalition()
    local g_type = group:getCategory()
    local next_g_name = g_me .. '_' .. timer.getTime()

    duty_shifts.DATA.on_duty[g_key] = nil
    duty_shifts.DATA.on_rtb[g_key] = true
    
    local next_duty = util.group.generateGroupTableFromME(g_me)

    next_duty.groupId = nil
    next_duty.name = next_g_name
    next_duty.lateActivation = false

    for unit_key, v_x in pairs(next_duty.units) do
        next_duty.units[unit_key]['unitId'] = nil
        local suffix = math.random(1e8, 1e9)
        next_duty.units[unit_key]['name'] = next_duty.units[unit_key]['name'] .. suffix
    end

    coalition.addGroup(coal_id, g_type, next_duty)
    duty_shifts.DATA.on_duty[next_g_name] = g_me
end


-- delete all units which are monitored by this extension
-- restore initial state, by respawning gorups defined in ME
--
-- INFO: resets units which are not-yet RTB aswell
function duty_shifts.watcher.revert_changes()
    
    for group_key, g_me in pairs(duty_shifts.DATA.on_duty) do
        local group = Group.getByName(group_key)
        if group ~= nil then
            local coal_id = group:getCoalition()
            local g_type = group:getCategory()
            local next_duty = util.group.generateGroupTableFromME(g_me)

            coalition.addGroup(coal_id, g_type, next_duty)
            group:destroy()
        end
    end
end
