convoy.DATA = {}

convoy.DATA.SOUND = "MissionStart.ogg"

-- all mission events this module can throw. Only use this locally
convoy.DATA.EVENT_TYPES = {
    C_CREATE   =  1,
    C_SUCCESS  =  2,
    C_FAILURE  =  3,
}

-- event template every throw uses
convoy.DATA.EVENT_TEMPLATE = {
    name    = "CONVOY",
    id      = nil, -- event id
    group   = nil, -- group
}

convoy.DATA.COUNT = {
    MIN = 7,
    MAX = 12,
}

convoy.DATA.UNIT_TEMPLATE = {
    ["type"] = nil,
    ["x"] = nil,
    ["y"] = nil,
    ["name"] = nil,
    ["skill"] = "Excellent",
    ["heading"] = 0,
}

convoy.DATA.GROUP_TEMPLATE = {
    ["name"] = nil,
    ["route"] = {},
    ["taskSelected"] = true,
    ["start_time"] = 0,
    ["task"] = "Ground Nothing",
}

convoy.DATA.DEFINITION = {
    ["LEAD"] = "T-90",
    ["MAIN"] = {
        ["T-90"]    =      { prob = 0.25 },
        ["T-72B3"]  =      { prob = 0.50 },
        ["BTR-82A"] =      { prob = 0.75 },
        ["BTR-80"]  =      { prob = 0.75 },
        ["T-80UD"]  =      { prob = 0.50 },
    },
    ["SPECIAL"] = {
        ["2S6 Tunguska"] = { min = 0, max = 3 },
    }
}