util.coords = {}

--- converts lat, long (deg, decimal degrees) in lat long (deg, min, decimal min)
--- @param lat number latitude (deg)
--- @param lng number longitude (deg)
--- @return table, table { hem = hemisphere, deg = degree, min = decimal min }
function util.coords.DDtoDMDM(lat, lng)
    if not tonumber(lat) then error(util.error.argErr(lat, "number", 1)) end
    if not tonumber(lat) then error(util.error.argErr(lng, "number", 2)) end

    local hemLat = lat >= 0 and "N" or "S"
    local hemLng = lng >= 0 and "E" or "W"

    local absLat, absLng = math.abs(lat), math.abs(lng)

    local dLat, dLng = math.floor(absLat), math.floor(absLng)
    local mLat, mLng = 60*(absLat - dLat), 60*(absLng - dLng)

    return { hem = hemLat, deg = dLat, min = mLat }, { hem = hemLng, deg = dLng, min = mLng }
end

--- returns a uniform string for diplay of DMDM coordinates | nil
--- @param dmdmLat table latitude (see DDtoDMDM)
--- @param dmdmLng table longitude (see DDtoDMDM)
--- @return string, string
function util.coords.DMDMString(dmdmLat, dmdmLng)
    if type(dmdmLat) ~= "table" then error(util.error.argErr(dmdmLat, "table", 1)) end
    if type(dmdmLng) ~= "table" then error(util.error.argErr(dmdmLng, "table", 2)) end

    local latStr = tostring(dmdmLat.hem) .. " " .. tostring(dmdmLat.deg) .. "°" .. string.format("%.5f", dmdmLat.min)
    local lngStr = tostring(dmdmLng.hem) .. " " .. tostring(dmdmLng.deg) .. "°" .. string.format("%.5f", dmdmLng.min)

    return latStr, lngStr
end

--- returns a uniform string for diplay of mgrs
--- @param mgrs table dcs mgrs table (see DCS MGRS)
--- @return string, string
function util.coords.MGRSString(mgrs)
    if type(mgrs) ~= "table" then error(util.error.argErr(mgrs, "table", 1)) end

    return mgrs.UTMZone .. ' ' .. mgrs.MGRSDigraph .. ' ' .. string.format("%05d", mgrs.Easting) .. ' ' .. string.format("%05d",mgrs.Northing)
end
