util.nation = {}

util.nation.definitions = {}

--- registers all nation present in DCS and genereates pattern for it
--- @return nil
function util.nation.registerNationsFromDCS()
    -- generate a pattern for every dcs nation 
    for id, name in pairs(country.names) do
        local pattern = util.naming.generatePattern(name)

        -- keep the pattern in a table, so we could expand nation attributes in the future
        util.nation.definitions[name] = {
            namingPattern = pattern,
        }
    end

    return nil
end

--- retruns the nation name pattern for the given nation
---
--- INFO: if no nation could be found for the unit, this funciton will return nil
--- @param nationName string nation name
--- @return string|nil pattern
function util.nation.getPatternByName(nationName)
    if type(nationName) ~= "string" then error(util.error.argErr(nationName, "string", 1)) end

    return util.nation.definitions[nationName].namingPattern
end

--- returns a table (key = name, value = pattern) of all nations and their patterns
--- @return table patterns
function util.nation.getPatternTable()
    return util.misc.map(util.nation.definitions, function(v, k) return v.namingPattern ,k end)
end

--- returns true if a unit is inside the nations territory
--- @param nationName string nation name
--- @param pos table position (vec2)
--- @return boolean inTerritory
function util.nation.posOnNationTerritory(nationName, pos)
    if type(nationName) ~= "string" then error(util.error.argErr(nationName, "string", 1)) end
    if type(pos) ~= "table" then error(util.error.argErr(pos, "table", 2)) end

    local nationObj = util.nation.definitions[nationName]
    if not nationObj then error(util.error.preconditionFailedErr("no nation entry found for nation '"..tostring(nationName).."'")) end

    return util.polygon.pointInPolygon(pos, nationObj.namingPattern)
end
